
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `kmbsf_appconfig`
--

DROP TABLE IF EXISTS `kmbsf_appconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kmbsf_appconfig` (
  `param_name` varchar(100) NOT NULL,
  `param_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`param_name`),
  UNIQUE KEY `param_name_UNIQUE` (`param_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kmbsf_auditlog`
--

DROP TABLE IF EXISTS `kmbsf_auditlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kmbsf_auditlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(45) NOT NULL,
  `rel_object_type` varchar(45) DEFAULT NULL,
  `rel_object_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `date_idx` (`date`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kmbsf_discoverNetworks`
--

DROP TABLE IF EXISTS `kmbsf_discoverNetworks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kmbsf_discoverNetworks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `network` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `netmask` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `community` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT 'public',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;


ALTER TABLE `kmbsf_equipment` 
ADD COLUMN `snmp_community` varchar(255) COLLATE utf8_bin DEFAULT NULL AFTER `field3`,
ADD COLUMN `market` INT(3) NULL DEFAULT 0 AFTER `date`,
CHANGE COLUMN `date` `date` DATE NOT NULL DEFAULT '1970-01-01';

DROP TABLE IF EXISTS `kmbsf_counter_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kmbsf_counter_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serialNumber` varchar(255) COLLATE utf8_bin NOT NULL,
  `copiesNB` int(11) NOT NULL,
  `copiesC` int(11) NOT NULL,
  `copiesC1` int(11) NOT NULL,
  `copiesC2` int(11) NOT NULL,
  `impressionsNB` int(11) NOT NULL,
  `impressionsFaxNB` int(11) NOT NULL,
  `impressionsFaxNB1` int(11) NOT NULL,
  `impressionsFaxNB2` int(11) NOT NULL,
  `impressionsMono` int(11) NOT NULL,
  `impressionsC` int(11) NOT NULL,
  `impressionsC2` int(11) NOT NULL,
  `impressionsFaxC` int(11) NOT NULL,
  `rectoVerso` int(11) NOT NULL,
  `marianne1` int(11) NOT NULL,
  `marianne2` int(11) NOT NULL,
  `scan` int(11) NOT NULL,
  `hexString` int(11) NOT NULL,
  `totalNB` int(11) NOT NULL,
  `totalC` int(11) NOT NULL,
  `totalCopiesC` int(11) NOT NULL,
  `totalCopiesNB` int(11) NOT NULL,
  `totalCopies` int(11) NOT NULL,
  `totalMono` int(11) NOT NULL,
  `totalImpressionsC` int(11) NOT NULL,
  `totalImpressionsNB` int(11) NOT NULL,
  `totalImpressions` int(11) NOT NULL,
  `totalFax` int(11) NOT NULL,
  `totalScan` int(11) NOT NULL,
  `totalMarianne` int(11) NOT NULL,
  `totalRectoVerso` int(11) NOT NULL,
  `date` date NOT NULL DEFAULT '1970-01-01',
  `market` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `serialNumber_date_idx` (`serialNumber`,`date`),
  KEY `serialNumber_idx` (`serialNumber`),
  KEY `date_idx` (`date`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
/*!40101 SET character_set_client = @saved_cs_client */;


DROP TRIGGER IF EXISTS kmbsf_equipment_AFTER_INSERT ;
DROP TRIGGER IF EXISTS kmbsf_equipment_AFTER_UPDATE ;

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50003 TRIGGER `kmbsf_equipment_AFTER_INSERT` AFTER INSERT ON `kmbsf_equipment` FOR EACH ROW
BEGIN
  INSERT INTO `kmbsf_counter_history` SET
    `serialNumber` = NEW.serialNumber,
    `copiesNB` = NEW.copiesNB,
    `copiesC` = NEW.copiesC,
    `copiesC1` = NEW.copiesC1,
    `copiesC2` = NEW.copiesC2,
    `impressionsNB` = NEW.impressionsNB,
    `impressionsFaxNB` = NEW.impressionsFaxNB,
    `impressionsFaxNB1` = NEW.impressionsFaxNB1,
    `impressionsFaxNB2` = NEW.impressionsFaxNB2,
    `impressionsMono` = NEW.impressionsMono,
    `impressionsC` = NEW.impressionsC,
    `impressionsC2` = NEW.impressionsC2,
    `impressionsFaxC` = NEW.impressionsFaxC,
    `rectoVerso` = NEW.rectoVerso,
    `marianne1` = NEW.marianne1,
    `marianne2` = NEW.marianne2,
    `scan` = NEW.scan,
    `hexString` = NEW.hexString,
    `totalNB` = NEW.totalNB,
    `totalC` = NEW.totalC,
    `totalCopiesC` = NEW.totalCopiesC,
    `totalCopiesNB` = NEW.totalCopiesNB,
    `totalCopies` = NEW.totalCopies,
    `totalMono` = NEW.totalMono,
    `totalImpressionsC` = NEW.totalImpressionsC,
    `totalImpressionsNB` = NEW.totalImpressionsNB,
    `totalImpressions` = NEW.totalImpressions,
    `totalFax` = NEW.totalFax,
    `totalScan` = NEW.totalScan,
    `totalMarianne` = NEW.totalMarianne,
    `totalRectoVerso` = NEW.totalRectoVerso,
    `date` = NEW.date,
    `market` = NEW.market
  ON DUPLICATE KEY UPDATE
    `serialNumber` = NEW.serialNumber,
    `copiesNB` = NEW.copiesNB,
    `copiesC` = NEW.copiesC,
    `copiesC1` = NEW.copiesC1,
    `copiesC2` = NEW.copiesC2,
    `impressionsNB` = NEW.impressionsNB,
    `impressionsFaxNB` = NEW.impressionsFaxNB,
    `impressionsFaxNB1` = NEW.impressionsFaxNB1,
    `impressionsFaxNB2` = NEW.impressionsFaxNB2,
    `impressionsMono` = NEW.impressionsMono,
    `impressionsC` = NEW.impressionsC,
    `impressionsC2` = NEW.impressionsC2,
    `impressionsFaxC` = NEW.impressionsFaxC,
    `rectoVerso` = NEW.rectoVerso,
    `marianne1` = NEW.marianne1,
    `marianne2` = NEW.marianne2,
    `scan` = NEW.scan,
    `hexString` = NEW.hexString,
    `totalNB` = NEW.totalNB,
    `totalC` = NEW.totalC,
    `totalCopiesC` = NEW.totalCopiesC,
    `totalCopiesNB` = NEW.totalCopiesNB,
    `totalCopies` = NEW.totalCopies,
    `totalMono` = NEW.totalMono,
    `totalImpressionsC` = NEW.totalImpressionsC,
    `totalImpressionsNB` = NEW.totalImpressionsNB,
    `totalImpressions` = NEW.totalImpressions,
    `totalFax` = NEW.totalFax,
    `totalScan` = NEW.totalScan,
    `totalMarianne` = NEW.totalMarianne,
    `totalRectoVerso` = NEW.totalRectoVerso,
    `date` = NEW.date,
    `market` = NEW.market;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50003 TRIGGER `kmbsf_equipment_AFTER_UPDATE` AFTER UPDATE ON `kmbsf_equipment` FOR EACH ROW
BEGIN
  IF NEW.copiesNB != OLD.copiesNB OR
    NEW.copiesC != OLD.copiesC OR
    NEW.copiesC1 != OLD.copiesC1 OR
    NEW.copiesC2 != OLD.copiesC2 OR
    NEW.impressionsNB != OLD.impressionsNB OR
    NEW.impressionsFaxNB != OLD.impressionsFaxNB OR
    NEW.impressionsFaxNB1 != OLD.impressionsFaxNB1 OR
    NEW.impressionsFaxNB2 != OLD.impressionsFaxNB2 OR
    NEW.impressionsMono != OLD.impressionsMono OR
    NEW.impressionsC != OLD.impressionsC OR
    NEW.impressionsC2 != OLD.impressionsC2 OR
    NEW.impressionsFaxC != OLD.impressionsFaxC OR
    NEW.rectoVerso != OLD.rectoVerso OR
    NEW.marianne1 != OLD.marianne1 OR
    NEW.marianne2 != OLD.marianne2 OR
    NEW.scan != OLD.scan OR
    NEW.hexString != OLD.hexString OR
    NEW.totalNB != OLD.totalNB OR
    NEW.totalC != OLD.totalC OR
    NEW.totalCopiesC != OLD.totalCopiesC OR
    NEW.totalCopiesNB != OLD.totalCopiesNB OR
    NEW.totalCopies != OLD.totalCopies OR
    NEW.totalMono != OLD.totalMono OR
    NEW.totalImpressionsC != OLD.totalImpressionsC OR
    NEW.totalImpressionsNB != OLD.totalImpressionsNB OR
    NEW.totalImpressions != OLD.totalImpressions OR
    NEW.totalFax != OLD.totalFax OR
    NEW.totalScan != OLD.totalScan OR
    NEW.totalMarianne != OLD.totalMarianne OR
    NEW.totalRectoVerso != OLD.totalRectoVerso OR
    NEW.market != OLD.market THEN
  INSERT INTO `kmbsf_counter_history` SET
    `serialNumber` = OLD.serialNumber,
    `copiesNB` = OLD.copiesNB,
    `copiesC` = OLD.copiesC,
    `copiesC1` = OLD.copiesC1,
    `copiesC2` = OLD.copiesC2,
    `impressionsNB` = OLD.impressionsNB,
    `impressionsFaxNB` = OLD.impressionsFaxNB,
    `impressionsFaxNB1` = OLD.impressionsFaxNB1,
    `impressionsFaxNB2` = OLD.impressionsFaxNB2,
    `impressionsMono` = OLD.impressionsMono,
    `impressionsC` = OLD.impressionsC,
    `impressionsC2` = OLD.impressionsC2,
    `impressionsFaxC` = OLD.impressionsFaxC,
    `rectoVerso` = OLD.rectoVerso,
    `marianne1` = OLD.marianne1,
    `marianne2` = OLD.marianne2,
    `scan` = OLD.scan,
    `hexString` = OLD.hexString,
    `totalNB` = OLD.totalNB,
    `totalC` = OLD.totalC,
    `totalCopiesC` = OLD.totalCopiesC,
    `totalCopiesNB` = OLD.totalCopiesNB,
    `totalCopies` = OLD.totalCopies,
    `totalMono` = OLD.totalMono,
    `totalImpressionsC` = OLD.totalImpressionsC,
    `totalImpressionsNB` = OLD.totalImpressionsNB,
    `totalImpressions` = OLD.totalImpressions,
    `totalFax` = OLD.totalFax,
    `totalScan` = OLD.totalScan,
    `totalMarianne` = OLD.totalMarianne,
    `totalRectoVerso` = OLD.totalRectoVerso,
    `date` = OLD.date,
    `market` = OLD.market
  ON DUPLICATE KEY UPDATE
    `serialNumber` = OLD.serialNumber,
    `copiesNB` = OLD.copiesNB,
    `copiesC` = OLD.copiesC,
    `copiesC1` = OLD.copiesC1,
    `copiesC2` = OLD.copiesC2,
    `impressionsNB` = OLD.impressionsNB,
    `impressionsFaxNB` = OLD.impressionsFaxNB,
    `impressionsFaxNB1` = OLD.impressionsFaxNB1,
    `impressionsFaxNB2` = OLD.impressionsFaxNB2,
    `impressionsMono` = OLD.impressionsMono,
    `impressionsC` = OLD.impressionsC,
    `impressionsC2` = OLD.impressionsC2,
    `impressionsFaxC` = OLD.impressionsFaxC,
    `rectoVerso` = OLD.rectoVerso,
    `marianne1` = OLD.marianne1,
    `marianne2` = OLD.marianne2,
    `scan` = OLD.scan,
    `hexString` = OLD.hexString,
    `totalNB` = OLD.totalNB,
    `totalC` = OLD.totalC,
    `totalCopiesC` = OLD.totalCopiesC,
    `totalCopiesNB` = OLD.totalCopiesNB,
    `totalCopies` = OLD.totalCopies,
    `totalMono` = OLD.totalMono,
    `totalImpressionsC` = OLD.totalImpressionsC,
    `totalImpressionsNB` = OLD.totalImpressionsNB,
    `totalImpressions` = OLD.totalImpressions,
    `totalFax` = OLD.totalFax,
    `totalScan` = OLD.totalScan,
    `totalMarianne` = OLD.totalMarianne,
    `totalRectoVerso` = OLD.totalRectoVerso,
    `date` = OLD.date,
    `market` = OLD.market;
  END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `kmbsf_lastExecutionResult`
--

DROP TABLE IF EXISTS `kmbsf_lastExecutionResult`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kmbsf_lastExecutionResult` (
  `task` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `executionDate` datetime NOT NULL,
  `running` tinyint(1) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kmbsf_notifications`
--

DROP TABLE IF EXISTS `kmbsf_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kmbsf_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(100) NOT NULL,
  `rcpt` varchar(100) NOT NULL,
  `type` tinyint(3) NOT NULL,
  `frequency` tinyint(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

UPDATE `kmbsf_equipment` SET `market` = '2' WHERE `market` = '0'